<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function packages()
    {
        return $this->hasManyThrough('App\Models\Package', 'App\Models\Purchase');
    }

    public function purchases()
    {
        return $this->hasMany('App\Models\Purchase');
    }

    public function school()
    {
        return $this->belongsTo('App\Models\School');
    }

    public function notes()
    {
        return $this->hasMany('App\Models\Note');
    }

}